﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;


namespace BMS.Facade.Service
{
    /// <summary>
    /// Wrapper that converts the datetimes properties on the entity to utc and then delegates to WFFactory.
    /// </summary>
    public interface IWorkflowOperations
    {
        II CreateBedUnavailable(BedUnavailable bedUnavailable, Facility facility);
        void UpdateBedUnavailable(BedUnavailable bedUnavailable, Facility facility);
        void CancelBedUnavailable(BedUnavailable bedUnavailable, Facility facility);        

        void UndoRemoveFromWaitingList(WaitingListItem waitingListItem, Facility facility);
        void RemoveFromWaitingList(WaitingListItem waitingListItem, Facility facility);
        void ModifyWaitingListItem(WaitingListItem waitingListItem, Facility facility);
        II CreateWaitingListItem(WaitingListItem waitingListItem, Facility facility);

        void UpdateTransferRequest(Transfer transferRequest, Facility facility);
        II CreateTransferRequest(Transfer transferRequest, Facility facility);
        II CreateTransferEvent(Transfer transferEvent, Facility facility);
    }
}
